//
//  GSUserDataProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 27.02.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSUserDataProtocol <NSObject>

/**
 Place (for plugins) to store custom data.

 Here it is possible to store something. Please use a unique key.
 The objects should be able to serialize to a plist. If they are not, they should return all infos to store in description (as String).
 */
@property (strong, nonatomic, nullable) NSDictionary *userData;

/**
 The number of top level items in userData
 */
- (NSUInteger)countOfUserData;

/**
 Accessor to get to the content from the userData dict

 @param key the key
 @return the data stored with key
 */
- (nullable id)userDataForKey:(nonnull NSString *)key;

#ifndef GLYPHS_VIEWER
/**
 Adds something to the fonts userData.

 This also triggers undo/document dirty state.

 @param value The object should be able to serialize to a plist. If they are not, they should return all infos to store in description (as String).
 @param key   Please use an uniqe key that gives some indecation who put it there (e.g. prefix it with your name or project).
 */
- (void)setUserData:(nullable id)value forKey:(nonnull NSString *)key;

/**
 adds all key/values from dict to userdata
 @param dict the dictionary to add
 */

- (void)addUserData:(NSDictionary *)dict;

/** Removed the object with this key.

 @param key The entry for that key will be removed
 */
- (void)removeUserDataForKey:(nonnull NSString *)key;

#endif
@end

NS_ASSUME_NONNULL_END
